<?php
/**
 * Template scriptcase.
 *
 * Modal de alerta para extensões não suportadas.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    23/03/2018
 * @copyright   NetMake Solucoes em Informatica
 * @author      Henrique Barros <h.barros@scriptcase.net>
 *
 * $Id: body_unsupported_extension.tpl.php,v 1.4 2018-03-23 14:11:55 henrique Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976))
{
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}
?>


<i class="close icon"></i>
<div class="header template-body">
    <div class="title">
        <?php echo nm_get_text_lang("['general_send_lang_title']"); ?>
    </div>
</div>
<div class="description content template-body">
    <div id="center-icon" class="hide">
        <i class="fa"></i>
    </div>
    <div class="message-container">
        <div class="icon"><i class="fa fa-question-circle confirm-icon"></i></div>
        <div class="text">
            <div id="cmessage" class="message">
                <?php echo nm_get_text_lang("['general_send_lang_message']"); ?>
            </div>
        </div>
    </div>
</div>
<div id="save-default-buttons" class="actions template-body" style="display: none">
    <span class="button-do"><?php echo nm_get_text_lang("['option_send']"); ?></span>
    <span class="button-dont"><?php echo nm_get_text_lang("['option_dont_send']"); ?></span>
    <span class="button-do-save"><?php echo nm_get_text_lang("['option_save']"); ?></span>
    <span class="button-dont-save"><?php echo nm_get_text_lang("['option_dont_save']"); ?></span>
</div>
<div id="save_button_holder" class="actions template-body" style="flex-direction: row-reverse;">
    <input type="button" tabindex="0" name="SAVE" value="<?php echo nm_get_text_lang("['option_send']"); ?>" id="save-confirm-button" onclick="" class="ui primary button button-do">
    <input type="button" name="NOSAVE" value="<?php echo nm_get_text_lang("['option_dont_send']"); ?>" id="save-deny-button" onclick="" class="ui basic red button button-dont">
    <div class="btn-separator-flex"></div>
    <input type="button" name="CANCEL" value="<?php echo nm_get_text_lang("['button_cancel']"); ?>" onclick="$('#general_save_message').modal('hide');" class="ui button">
</div>
<div id="save-default-message" style="display: none !important;">
    <div class="title">
        <?php echo nm_get_text_lang("['general_confirm_title']"); ?>
    </div>
    <div class="message">
        <?php echo nm_get_text_lang("['general_confirm_message']"); ?>
    </div>
</div>

<style>
    #general_save_message {
        width: 450px;
        margin: 0 0 0 -225px;
    }
    #general_save_message #custom-message {
        display: none;
    }
    #general_save_message .message-container {
        display: flex;
        flex-direction: row;
        justify-content: center;
    }
    #general_save_message .message-container > .icon {
        justify-content: center;
        display: flex;
        flex-direction: column;
        text-align: center;
        padding: 0 10px 0 25px;
    }
    #general_save_message .message-container > .icon.none {
        display: none;
    }
    #general_save_message .message-container > .text {
        display: flex;
        flex-direction: column;
        justify-content: center;
        text-align: center;
        flex-grow: 1;
    }
    #general_save_message .message {
        font-size: 14px;
        text-align: left;
    }
    #general_save_message .title {
        font-weight: bold;
        font-size: 14px;
        text-align: left;
        min-height: 25px;
    }
    #general_save_message #save_button_holder {
        display: flex;
        flex-direction: row;
        column-gap: 10px;
        justify-content: center;
        align-items: center;
    }
    #general_save_message #save_button_holder > * {
        margin: 0 !important;
    }
    #general_save_message h1 {
        height: 80px;
        position: relative;
    }
    #general_save_message .error-icon.none {
        display: none;
    }
    #general_save_message .confirm-icon {
        color: #7c9eec;
    }
    #general_save_message .confirm-icon:before {
        color: inherit;
        font-size: 50px;
    }
    #general_save_message .btn-separator-flex {
        flex-grow: 1;
    }
    #general_save_message .icon.none {
        display: none;
    }
</style>